/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/
#ifndef WAYLANDBACKEND_WLSEAT
#define WAYLANDBACKEND_WLSEAT 1

#include <string>
#include <wayland-client.h>
#include "WLInterface.hpp"

namespace WaylandBackend
{
class WLKeyboard;
class WLPointer;
class WLTouch;

class WLSeat : public WLInterface
{
public:
    WLSeat(struct wl_event_queue *eventQ);
    virtual ~WLSeat();
    std::string& getSeatName();
    
    struct wl_seat* get_seat() { return _wlSeat; }
	
	int init(struct wl_registry* registry, uint32_t name,
             const char* interface, uint32_t version);

    uint32_t getWLID();
    std::string& getWLName();
    void surfaceDestroyNotification(struct wl_surface *wlSurface);

private:
    struct wl_seat*        _wlSeat;
    struct wl_event_queue* _wlEventQ;
    std::string            _wlInterfaceName;
    uint32_t               _wlID;
    std::string            _WLSeatName;
    WLKeyboard*            _keyboard_dev;
    WLPointer*             _pointer_dev;
    WLTouch*               _touch_dev;
    
    static const struct wl_seat_listener seatListener;

    static void seatCapabilities(void* data, struct wl_seat* seat, uint32_t caps);
    static void seatName(void* data, struct wl_seat* seat, const char *name);
};

}

#endif
